public final class Point {
    // finalisierte, private Felder zu den Komponenten
    private final int x;
    private final int y;

    // (Kanonischer) Konstruktor
    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    // Getter
    int x() { return x; }
    int y() { return y; }

    // equals() - Überschreibung mit inhaltsorientierter Beurteilung
    public boolean equals(Object obj) {
        if (this == obj)
			return true;
		if (obj == null || !(obj instanceof Point))
            return false;
        Point p = (Point) obj;
        return p.x == this.x  &&  p.y == this.y;
    }

    // Mit equals() kompatible hashCode() - Überschreibung
    public int hashCode() {
        return java.util.Objects.hash(x, y);
    }

    // toString() - Überschreibung
    public String toString() {
        return "Point[x=" + this.x + ", y=" + this.y + "]";
    }
}